unit RgReaderApiDef;

interface

type

  TMfCardType = (CT_Unknown = 0, CT_Tag, CT_DesFire, CT_Ultalight,
    CT_Classic_1K_SmartMX, CT_Classic_4K_SmartMX, CT_Classic_mini,
    CT_Classic_1K, CT_Classic_2K, CT_Classic_4K, CT_Plus_Unc_Unc_sl0,
    CT_Plus_SE_1K_sl0, CT_Plus_SE_1K_sl1, CT_Plus_SE_1K_sl2, CT_Plus_SE_1K_sl3,
    CT_Plus_S_2K_sl0, CT_Plus_Unc_Unc_sl1, CT_Plus_S_2K_sl1, CT_Plus_S_2K_sl2,
    CT_Plus_S_2K_sl3, CT_Plus_S_4K_sl0, CT_Plus_S_4K_sl1, CT_Plus_S_4K_sl2,
    CT_Plus_S_4K_sl3, CT_Plus_X_2K_sl0, CT_Plus_X_2K_sl1, CT_Plus_X_2K_sl2,
    CT_Plus_X_2K_sl3, CT_Plus_X_4K_sl0, CT_Plus_Unc_Unc_sl3, CT_Plus_X_4K_sl1,
    CT_Plus_X_4K_sl2, CT_Plus_X_4K_sl3);

  TMfSecLevelType = (LT_None = 0, LT_Classic, LT_Sl0, LT_Sl1, LT_Sl2, LT_Sl3);
  TMfTargetLevel = (Tl_SL1 = 0, Tl_SL3);

  /// <summary>
  ///  
  /// </summary>
  TRG_ENDPOINT_TYPE = (
    /// <summary>
    /// - , 
    /// </summary>
    ET_UNKNOWN = 0,
    /// <summary>
    /// USB HID
    /// </summary>
    ET_USBHID,
    /// <summary>
    ///  
    /// </summary>
    ET_SERIAL);

  /// <summary>
  ///  
  // -----------------------------  USB ....
  /// </summary>
  TRG_DEVICE_TYPE = (
    /// <summary>
    ///   RDR-202
    /// </summary>
    DTE_RDR202 = $04,
    /// <summary>
    /// USB  R10-EHT
    /// </summary>
    DTE_R10EHT = $0A,
    /// <summary>
    /// USB  R10-MF
    /// </summary>
    DTE_R10MF = $0B,
    /// <summary>
    /// USB  R15 Multi
    /// </summary>
    DTE_R15MULTI = $0F,
    /// <summary>
    /// USB  R5-USB Multi
    /// </summary>
    DTE_R5USBMULTI = $10,
    /// <summary>
    /// USB  R5-USB Multi Prof
    /// </summary>
    DRTE_R5USBMULTIPROF = $11,
    /// <summary>
    ///  RDR204-EH Key
    /// </summary>
    DTE_RDR204EH = $0C,
    /// <summary>
    ///  RDR204-MF Key
    /// </summary>
    DTE_RDR204MF = $0D,
    /// <summary>
    ///  RDR-102
    /// </summary>
    DTE_RDR102 = $0E);

  /// <summary>
  ///   
  /// </summary>
  TRG_CARD_TYPE_CODE = (
    /// <summary>
    /// PIN  
    /// </summary>
    CTC_PIN = $00,
    /// <summary>
    ///  Temic
    /// </summary>
    CTC_TEMIC = $01,
    /// <summary>
    ///  HID
    /// </summary>
    CTC_HID = $02,
    /// <summary>
    ///  Em-Marine
    /// </summary>
    CTC_EM = $03,
    /// <summary>
    ///  Indala
    /// </summary>
    CTC_INDALA = $04,
    /// <summary>
    ///  COTAG
    /// </summary>
    CTC_COTAG = $05,
    /// <summary>
    ///  MIFARE DESFire EV1
    /// </summary>
    CTC_MF_DESFIRE = $06,
    /// <summary>
    ///  MIFARE Ultralight
    /// </summary>
    CTC_MF_UL = $07,
    /// <summary>
    ///  MIFARE Mini
    /// </summary>
    CTC_MF_MINI = $08,
    /// <summary>
    ///  MIFARE Classic 1K / MIFARE Plus EV1 2K SL1
    /// </summary>
    CTC_MF_CL1K_PL2K = $09,
    /// <summary>
    ///  MIFARE Classic 4K / MIFARE Plus EV1 4K SL1
    /// </summary>
    CTC_MF_CL4K_PL4K = $0A,
    /// <summary>
    ///  MIFARE Plus 2K SL2
    /// </summary>
    CTC_MF_PL2K_SL2 = $0B,
    /// <summary>
    // -------------------------------   
    ///  MIFARE Plus 4K SL2
    /// </summary>
    CTC_MF_PL4K_SL2 = $0C,
    /// <summary>
    ///  MIFARE Plus SL3
    /// </summary>
    CTC_MF_SL3 = $0D,
    /// <summary>
    ///  SmartMX 4K
    /// </summary>
    CTC_SMX4K = $0E,
    /// <summary>
    ///    
    /// </summary>
    CTC_CloneOnTemic = $40,
    /// <summary>
    ///  SmartMX 1K
    /// </summary>
    CTC_SMX1K = $0F,
    /// <summary>
    ///   PAY
    /// </summary>
    CTC_PAY = $FD,
    /// <summary>
    ///   
    /// </summary>
    CTC_MOBILE = $FE);

  /// <summary>
  ///   
  /// </summary>
  TRG_CARD_FAMILY_CODE = (
    /// <summary>
    ///   
    /// </summary>
    CF_PIN = 1,
    /// <summary>
    /// Temic
    /// </summary>
    CF_TEMIC = 2,
    /// <summary>
    /// HID
    /// </summary>
    CF_HID = 4,
    /// <summary>
    /// Em-Marine
    /// </summary>
    CF_EM = 8,
    /// <summary>
    /// Indala
    /// </summary>
    CF_INDALA = 16,
    /// <summary>
    /// Cotag/Bewator
    /// </summary>
    CF_COTAG = 32,
    /// <summary>
    /// Mifare
    /// </summary>
    CF_MIFARE = 64,
    /// <summary>
    /// Indala MT
    /// </summary>
    CF_INDALA_MT = 128,
    /// <summary>
    ///  
    /// </summary>
    CF_ALL = 255);

  /// <summary>
  ///   
  /// </summary>
  TRG_STATUS_TYPE = (
    /// <summary>
    ///   
    /// </summary>
    STE_NO_CARD = 1,
    /// <summary>
    ///        
    /// </summary>
    STE_CARD = 9,
    /// <summary>
    ///   ,      
    /// </summary>
    STE_CARD_NO_AUTH = 10,
    /// <summary>
    ///      
    /// </summary>
    STE_CARD_AUTH = 26, STE_FirstStep = $FF);

  /// <summary>
  ///      Mifare
  /// </summary>
  TRG_CARD_AUTH_FLAGS = (
    /// <summary>
    ///  ,  Mifare Classic     B.    
    /// </summary>
    CAF_CLASSIC_KEY_B = 1,
    /// <summary>
    ///     Pay/.
    ///    
    /// </summary>
    CAF_GENERATED_KEY = 1,
    /// <summary>
    ///  ,  Mifare Plus     B.    
    /// </summary>
    CAF_PLUS_KEY_B = 2,
    /// <summary>
    ///     Pay/.
    ///    
    /// </summary>
    CAF_PRESENT_KEY = 2,
    /// <summary>
    ///  ,       SL3,  SL1/CLassic
    /// </summary>
    CAF_PLUS_SL3 = 4,
    /// <summary>
    ///     Pay/.
    ///    
    /// </summary>
    CAF_EMITED_KEY = 4,
    /// <summary>
    ///       
    ///   CAF_USE_PAY
    /// </summary>
    CAF_USE_APP = 16,
    /// <summary>
    ///      Pay
    ///   CAF_USE_APP
    /// </summary>
    CAF_USE_PAY = 32);

  /// <summary>
  ///     
  /// </summary>
  PRG_STATUS_TYPE = ^TRG_STATUS_TYPE;

  /// <summary>
  ///   API
  /// </summary>
  TError = (
    /// <summary>
    ///  
    /// </summary>
    EC_OK = 0,
    /// <summary>
    ///  
    /// </summary>
    EC_FAIL,
    /// <summary>
    ///   
    /// </summary>
    EC_NOT_IMPLEMENTED,
    /// <summary>
    ///     
    /// </summary>
    EC_BAD_ARGUMENT,
    /// <summary>
    ///    ,   
    /// </summary>
    EC_INVALID_HANDLE,
    /// <summary>
    ///    
    /// </summary>
    EC_INVALID_RESOURCE,
    /// <summary>
    ///    
    /// </summary>
    EC_INVALID_CONNECTION_TYPE,
    /// <summary>
    ///      
    /// </summary>
    EC_INVALID_CONNECTION_ADDRESS,
    /// <summary>
    ///         
    /// </summary>
    EC_INVALID_DEVICE_ADDRESS,
    /// <summary>
    ///     
    /// </summary>
    EC_DEVICE_OPERATION_UNSUPPORTED,
    /// <summary>
    ///       ( USB ).
    /// </summary>
    EC_DEVICE_NOT_CONNECTED,
    /// <summary>
    ///     
    /// </summary>
    EC_DEVICE_NO_RESPOND,
    /// <summary>
    ///     
    /// </summary>
    EC_DEVICE_COMM_FAILURE,
    /// <summary>
    ///      
    /// </summary>
    EC_DEVICE_PROTOCOL_FAILURE,
    /// <summary>
    ///   
    /// </summary>
    EC_POLL_NO_EVENTS,
    /// <summary>
    ///    
    /// </summary>
    EC_POLL_QUEUE_CLOSED,

    //  
    /// <summary>
    ///   
    /// </summary>
    EC_CALL_INIT,

    /// <summary>
    ///        
    /// </summary>
    EC_DEVICE_INVALID_COMMAND,

    /// <summary>
    ///    
    /// </summary>
    EC_DEVICE_INVALID_PARAM,

    /// <summary>
    ///  PIN   
    /// </summary>
    EC_DEVICE_INVALID_PIN,

    /// <summary>
    ///        
    /// </summary>
    EC_DEVICE_COMMAND_TIMEOUT,

    /// <summary>
    ///    
    /// </summary>
    EC_DEVICE_NO_CARD,

    /// <summary>
    ///     
    /// </summary>
    EC_DEVICE_UNKNOWN_CARD,

    /// <summary>
    ///     
    /// </summary>
    EC_DEVICE_INCOMPATIBLE_CARD,

    /// <summary>
    ///    
    /// </summary>
    EC_DEVICE_AUTH_FAIL,

    /// <summary>
    ///   
    /// </summary>
    EC_DEVICE_PROFILE_FAIL,

    /// <summary>
    ///         -------------------     ?
    /// </summary>
    EC_DEVICE_RW_FAIL,

    /// <summary>
    ///    
    /// </summary>
    EC_IO_OPEN_FAIL,
    /// <summary>
    ///    
    /// </summary>
    EC_IO_CLOSE_FAIL,
    /// <summary>
    ///    
    /// </summary>
    EC_IO_READ_FAIL,

    /// <summary>
    ///    
    /// </summary>
    EC_IO_WRITE_FAIL,

    /// <summary>
    ///  ,   
    /// </summary>
    EC_IO_CLOSED,

    /// <summary>
    ///   
    /// </summary>
    DEVICE_IN_BOOT,

    /// <summary>
    ///     
    /// </summary>
    ERROR_MODEL,

    /// <summary>
    ///    
    /// </summary>
    FILE_NOT_FOUND);

  /// <summary>
  ///       
  /// </summary>
  TRG_SETTINGS_BLOCK_TYPE = (
    /// <summary>
    ///  
    /// </summary>
    ESB_SETTINGS = 0,
    /// <summary>
    ///  
    /// </summary>
    ESB_PROFILES,
    /// <summary>
    ///  
    /// </summary>
    ESB_KEYS);

implementation

end.
